/**
 * Memory Analyser  version 1.00
 * Copyright (c) 2018, Tycho Veltmeijer.
 * All rights reserved.
**/

/*Deze code maakt een lijst aan, als er meer items aan de lijst toegevoegd zijn zal de lijst 2x zo groot worden gemaakt.*/

#include <stdio.h>
#include "list.h"

#include <string.h>
#include <time.h>
#include <Psapi.h>

/*Maak een lijst aan*/
void* createList() {
	void* list;
	void* listp;

	/*Een vaste pointer*/
	listp = (void*) malloc(sizeof(void*));

	/*Vraag geheugen aan vooor 100 pointers*/
	list = (void*) malloc(sizeof(void*)*100);
	/*Bereken hoeveel pointers er overblijven als er twee integers op worden geplaatst*/
	*(int*)list = ( (sizeof(void*)*100) - (sizeof(int) * 2)) / sizeof(void*);
	/*Hiervan zijn 0 plekken gebruikt*/
	*((int*)list+1) = 0;
	/*Zet de lijst op de pointer (op deze manier kan de lijst vervangen worden zonder dat de pointer naar de lijst verandert hoeft te worden*/
	*(void**)listp = list;

	return listp;
}

void addToList(void* list, void* value) {
	int* listOptions;
	void* list2;

	void* newList;
	int* newListInt;

	listOptions = (int*) *(void**) list;
	list2 = (void**) (listOptions+2);

	/*Maak een nieuwe grotere lijst aan indien er geen ruimte meer is*/
	if(*listOptions == *(listOptions+1)) {
		/*Vraag nieuw groter geheugen aan*/
		newList = malloc(((*listOptions) * 2 * sizeof(void*)) + (sizeof(int) * 2));
		newListInt = (int*) newList;

		/*Kopier de oude lijst naar de nieuwe*/
		*newListInt = (*listOptions) * 2;
		*(newListInt+1) = *(listOptions+1);
		memcpy(newListInt+2, list2, *(listOptions+1) * sizeof(void*));

		/*Geef de oude lijst vrij*/
		free(*(void**)list);
		/*vervang de pointer naar de lijst*/
		*(void**)list = newList;
		
		listOptions = (int*) *(void**) list;
		list2 = (void**) (listOptions+2);
	}

	* ( (void**)list2 + *(listOptions+1)) = value;
	*(listOptions+1) += 1;
}

/*Krijg item x van de lijst*/
void* getFromList(void* list, int id) {
	int* listOptions;
	void* list2;

	listOptions = (int*) *(void**) list;
	list2 = (void**) (listOptions+2);

	if(*(listOptions+1)<id-1)
		return 0;

	return * ( (void**)list2 + id);
}

/*Tel hoeveel pointers er op de lijst staan.*/
int countList(void* list) {
	int* listOptions;

	listOptions = (int*) *(void**) list;

	return *(listOptions+1);
}

void freeList(void* list) {
	free(*(void**) list);
	free(list);
}